// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : mainmenu.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////



#include "mainmenu.h"
#include "input.h"
#include "level.h"
#include "entityPlayer.h"
#include "Util.h"
#include "Button.h"
#include "Application.h"
#include "Editor.h"
#include "Game.h"
#include "Extro.h"
#include "Options.h"



Menu::Menu() 
{

  m_CurBarPos       = 320.0f;
  m_BarTargetTime   = 0.0f;

  m_BarPos          = 0;
  m_BarStartPos     = 0;

  m_BarXPos[0]      = 50;
  m_BarXPos[1]      = 30;
  m_BarXPos[2]      = 30;

  m_BarColor[0]     = 0xffffffff;
  m_BarColor[1]     = 0xffc0c0c0;
  m_BarColor[2]     = 0xffc0c0c0;

  m_ShowEnemies.push_back( std::make_pair( Dobbs::ENTITY_TYPE_BUG_L, "Bugbert" ) );
  m_ShowEnemies.push_back( std::make_pair( Dobbs::ENTITY_TYPE_FISH_L, "Phish" ) );
  m_ShowEnemies.push_back( std::make_pair( Dobbs::ENTITY_TYPE_FLY, "Leakfly" ) );
  m_ShowEnemies.push_back( std::make_pair( Dobbs::ENTITY_TYPE_PLAYER, "Dr.Dobb" ) );
  m_ShowEnemies.push_back( std::make_pair( Dobbs::ENTITY_TYPE_CAR, "The Car" ) );
  m_ShowEnemies.push_back( std::make_pair( Dobbs::ENTITY_TYPE_SUB, "The Sub" ) );

  m_CurEnemyTime    = 0.0f;
  m_pCurEnemy       = NULL;

}



Menu::~Menu() 
{

  delete m_pCurEnemy;

}



void Menu::Init()
{

}



void Menu::Exit()
{
}



void Menu::Update() 
{

  if ( g_App.m_Input.KeyPressed( VK_ESCAPE ) ) 
  { 
    g_App.CloseWindow();
  }
  if ( g_App.m_Input.KeyPressed( 'E' ) ) 
  {
    g_App.ChangeGameState( new Editor() );
    //g_App.ChangeGameState( new Extro() );
  }
  if ( g_App.m_Input.KeyPressed( 'P' ) ) 
  {
    g_App.ChangeGameState( new Game() );
  }

  if ( g_App.m_Input.KeyPressed( VK_UP ) ) 
  {
    if ( m_BarPos > 0 )
    {
      m_BarStartPos = m_BarPos;
      m_BarPos--;
      m_BarTargetTime = 0.25f;
      g_App.PlaySound( "Menu.Select" );
    }
  }
  if ( g_App.m_Input.KeyPressed( VK_DOWN ) ) 
  {
    if ( m_BarPos < 2 )
    {
      m_BarStartPos = m_BarPos;
      m_BarPos++;
      m_BarTargetTime = 0.25f;
      g_App.PlaySound( "Menu.Select" );
    }
  }
  if ( ( g_App.m_Input.KeyPressed( VK_RETURN ) ) 
  ||   ( g_App.m_Input.KeyPressed( VK_SPACE ) ) )
  {
    switch ( m_BarPos )
    {
      case 0:
        g_App.ChangeGameState( new Game() );
        break;
      case 1:
        g_App.ChangeGameState( new Options() );
        break;
      case 2:
        g_App.CloseWindow();
        break;
    }
  }

}



void Menu::UpdateTimed( const float ElapsedTime )
{

  if ( m_pCurEnemy )
  {
    m_pCurEnemy->UpdateAnimation( ElapsedTime );
  }

  m_CurEnemyTime -= ElapsedTime;
  if ( m_CurEnemyTime <= 0.0f )
  {
    m_CurEnemyTime = 5.0f;

    std::list<std::pair<Dobbs::EntityTypes,std::string> >::iterator   it( m_ShowEnemies.begin() );
    if ( m_pCurEnemy )
    {
      while ( it != m_ShowEnemies.end() )
      {
        if ( it->first == m_pCurEnemy->GetType() )
        {
          ++it;
          if ( it == m_ShowEnemies.end() )
          {
            it = m_ShowEnemies.begin();
          }
          break;
        }
        ++it;
      }
      delete m_pCurEnemy;
      m_pCurEnemy = NULL;
    }
    if ( it != m_ShowEnemies.end() )
    {
      m_pCurEnemy = Entity::SpawnEntity( it->first, 640, 450, Dobbs::DIR_LEFT );
      m_CurEnemyName  = it->second;
    }
  }

  if ( m_BarTargetTime > 0.0f )
  {
    m_BarTargetTime -= ElapsedTime;
    if ( m_BarTargetTime < 0.0f )
    {
      m_BarTargetTime = 0.0f;
    }
    m_CurBarPos = 320.0f + 100.0f * m_BarPos - 100.0f * ( m_BarPos - m_BarStartPos ) * sinf( 3.1415926f * 90.0f * ( m_BarTargetTime / 0.25f ) / 180.0f );
  }
  for ( int i = 0; i < 3; ++i )
  {
    if ( i == m_BarPos )
    {
      m_BarXPos[i] = 50 - (int)( 20 * m_BarTargetTime / 0.25f );

      m_BarColor[i] = Util::ModulateColor( 0xffffffff, 0xffc0c0c0, 1.0f - m_BarTargetTime / 0.25f );
    }
    else if ( i == m_BarStartPos )
    {
      m_BarXPos[i] = 30 + (int)( 20 * m_BarTargetTime / 0.25f );
      m_BarColor[i] = Util::ModulateColor( 0xffffffff, 0xffc0c0c0, m_BarTargetTime / 0.25f );
    }
    else
    {
      m_BarXPos[i] = 30;
      m_BarColor[i] = 0xffc0c0c0;
    }
  }

}



void Menu::OnMouseWheel( int Dir )
{

}



void Menu::Render()
{

  //g_App.Clear();
  g_App.RenderBackground();

  g_App.RenderTextureSection( "GUI.Dobbs", 215, 50 );
  g_App.RenderTextureSection( "GUI.Challenge", 138, 150 );

  g_App.RenderTextureSection( "GUI.Doctor", 640, 120 );

  g_App.RenderTextureSection( "Menu.Bar", 0, (int)m_CurBarPos );

  g_App.RenderTextureSection( "Menu.Play", m_BarXPos[0], 300, m_BarColor[0] );
  g_App.RenderTextureSection( "Menu.Options", m_BarXPos[1], 400, m_BarColor[1] );
  g_App.RenderTextureSection( "Menu.Quit", m_BarXPos[2], 500, m_BarColor[2] );

  if ( m_pCurEnemy )
  {
    m_pCurEnemy->Render( 0, 0 );

    g_App.RenderTextCentered( "GUI.Small", m_CurEnemyName, 640, 480 );
  }

  g_App.RenderTextRightAligned( "GUI.Small", VERSION_ID, Dobbs::SCREEN_WIDTH - 5, 2 );

}